package jamezo97.clonecraft.gui;

import jamezo97.clonecraft.entity.clone.EntityAttackEntry;
import jamezo97.clonecraft.entity.clone.EntityClone;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.CloneCraftEntityAccessor;
import net.minecraft.entity.EntityLiving;

import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

public class GuiChooseAttackSlot extends GuiSlot{

	GuiChooseAttackEntities parent;

	public GuiChooseAttackSlot(GuiChooseAttackEntities gui) {
		super(gui.getMc(), gui.width, gui.height, 32, gui.height-64, 36);
		parent = gui;
	}

	@Override
	protected int getSize() {
		return parent.allEntities.size();
	}

	@Override
	protected void elementClicked(int var1, boolean var2) {
		EntityAttackEntry entry = parent.allEntities.get(var1);

		if(parent.clone.options.shouldAttack(entry)){
			parent.clone.options.removeEntityToAttack(entry);
			parent.onRemove(entry);
		}else{
			parent.clone.options.addEntityToAttack(entry);
			parent.onAdd(entry);
			EntityLiving e = entry.instantiate(parent.clone.worldObj);
			if(e != null){
				String s = CloneCraftEntityAccessor.getHurtSound(e);
				if (s != null){
					EntityClone c = parent.clone;
					parent.clone.worldObj.playSound(c.posX, c.posY, c.posZ, s, CloneCraftEntityAccessor.getSoundVolume(e), CloneCraftEntityAccessor.getSoundPitch(e), true);
				}
			}

		}
	}

	@Override
	protected boolean isSelected(int var1) {
		EntityAttackEntry entry = parent.allEntities.get(var1);
		if(parent.clone.options.shouldAttack(entry)){
			return true;
		}
		return false;
	}



	@Override
	protected void drawBackground() {

	}

	@Override
	protected void drawSlot(int var1, int var2, int var3, int var4, Tessellator var5) {
		EntityAttackEntry entry = parent.allEntities.get(var1);
		parent.drawString(parent.getMc().fontRenderer, entry.name, var2, var3, 0xffffff);
		GL11.glPushMatrix();
		GL11.glTranslatef((float)var2 + 100f + (var1%2==0?75f:0f), (float)var3 + 30f, 75.0F);
		renderEntity(entry.instantiate(parent.clone.worldObj), 20, parent.rotX, parent.rotY, parent.rotZ);
		GL11.glPopMatrix();
	}

	public static void renderEntity(EntityLiving entity, float par3, double rotX, double rotY, double rotZ)
	{
		if(entity == null){
			return;
		}
		//1
		//4
		if(entity.width > 1){
			/*float scale1 = 1.0f / entity.height;
    		float scale2 = 1.0f / entity.width;
    		if(scale1 < scale2){
    			par3 = par3 * scale1;
    		}else{
    			par3 = par3 * scale2;
    		}*/
			double height = entity.boundingBox.maxY - entity.boundingBox.minY;
			par3 *= (1.6 / height);
		}
		float par4 = 0;
		float par5 = 0;
		GL11.glEnable(GL11.GL_COLOR_MATERIAL);
		GL11.glPushMatrix();
		GL11.glScalef((float)(-par3), (float)par3, (float)par3);
		GL11.glRotatef(180.0F, 0.0F, 0.0F, 1.0F);
		float var6 = entity.renderYawOffset;
		float var7 = entity.rotationYaw;
		float var8 = entity.rotationPitch;
		GL11.glRotatef(135.0F, 0.0F, 1.0F, 0.0F);
		RenderHelper.enableStandardItemLighting();
		GL11.glRotatef(-135.0F, 0.0F, 1.0F, 0.0F);
		GL11.glRotatef(-((float)Math.atan((double)(par5 / 40.0F))) * 20.0F, 1.0F, 0.0F, 0.0F);
		entity.renderYawOffset = (float)Math.atan((double)(par4 / 40.0F)) * 20.0F;
		entity.rotationYaw = (float)Math.atan((double)(par4 / 40.0F)) * 40.0F;
		entity.rotationPitch = -((float)Math.atan((double)(par5 / 40.0F))) * 20.0F;
		entity.rotationYawHead = entity.rotationYaw;
		GL11.glTranslatef(0.0F, entity.yOffset, 0.0F);
		RenderManager.instance.playerViewY = 180.0F;
		GL11.glRotated(rotX, 1, 0, 0);
		GL11.glRotated(rotY, 0, 1, 0);
		RenderManager.instance.renderEntityWithPosYaw(entity, 0.0D, 0.0D, 0.0D, 0.0F, 1.0F);
		entity.renderYawOffset = var6;
		entity.rotationYaw = var7;
		entity.rotationPitch = var8;
		GL11.glPopMatrix();
		RenderHelper.disableStandardItemLighting();
		GL11.glDisable(GL12.GL_RESCALE_NORMAL);
		OpenGlHelper.setActiveTexture(OpenGlHelper.lightmapTexUnit);
		GL11.glDisable(GL11.GL_TEXTURE_2D);
		OpenGlHelper.setActiveTexture(OpenGlHelper.defaultTexUnit);
	}

}
